/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.level.block.entity;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.core.ModServices;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.barteringstation.world.entity.monster.piglin.PiglinAiHelper;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import fuzs.barteringstation.world.level.BlockLightingUtil;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BarteringStationBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final String TAG_DELAY = "Delay";
    public static final int ALL_SLOTS = 21;
    public static final int CURRENCY_SLOTS = 6;
    public static final int DATA_SLOTS = 2;
    private static final int[] SLOTS_FOR_INPUT = (int[])Util.m_137469_((Object)new int[6], arr -> Arrays.setAll(arr, IntUnaryOperator.identity()));
    private static final int[] SLOTS_FOR_OUTPUT = (int[])Util.m_137469_((Object)new int[15], arr -> Arrays.setAll(arr, i -> i + 6));
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> BarteringStationBlockEntity.this.getBarterDelay();
                case 1 -> BarteringStationBlockEntity.this.nearbyPiglins;
                default -> throw new IndexOutOfBoundsException(id);
            };
        }

        public void m_8050_(int id, int data) {
        }

        public int m_6499_() {
            return 2;
        }
    };
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)21, (Object)ItemStack.f_41583_);
    private int barterDelay;
    private int nearbyPiglins;
    public int time;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    private float tRot;
    public int combinedLight;

    public BarteringStationBlockEntity(BlockPos p_155077_, BlockState p_155078_) {
        super((BlockEntityType)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.get(), p_155077_, p_155078_);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.barterDelay = tag.m_128448_(TAG_DELAY);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128376_(TAG_DELAY, (short)this.barterDelay);
    }

    public int getBarterDelay() {
        return Math.min(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay, this.barterDelay);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BarteringStationBlockEntity blockEntity) {
        float f2;
        blockEntity.oOpen = blockEntity.open;
        blockEntity.oRot = blockEntity.rot;
        Player player = level.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
            double d1 = player.m_20189_() - ((double)pos.m_123343_() + 0.5);
            blockEntity.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
            blockEntity.open += 0.1f;
        } else {
            blockEntity.tRot += 0.02f;
            blockEntity.open -= 0.1f;
        }
        while (blockEntity.rot >= (float)Math.PI) {
            blockEntity.rot -= (float)Math.PI * 2;
        }
        while (blockEntity.rot < (float)(-Math.PI)) {
            blockEntity.rot += (float)Math.PI * 2;
        }
        while (blockEntity.tRot >= (float)Math.PI) {
            blockEntity.tRot -= (float)Math.PI * 2;
        }
        while (blockEntity.tRot < (float)(-Math.PI)) {
            blockEntity.tRot += (float)Math.PI * 2;
        }
        for (f2 = blockEntity.tRot - blockEntity.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        blockEntity.rot += f2 * 0.4f;
        blockEntity.open = Mth.m_14036_((float)blockEntity.open, (float)0.0f, (float)1.0f);
        ++blockEntity.time;
        blockEntity.combinedLight = BlockLightingUtil.getLightColor((BlockAndTintGetter)level, blockEntity.m_58899_().m_7494_());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BarteringStationBlockEntity blockEntity) {
        int totalBarterDelay;
        boolean tryPerformBarter;
        if (blockEntity.barterDelay > 0) {
            --blockEntity.barterDelay;
        }
        boolean bl = tryPerformBarter = blockEntity.barterDelay % (totalBarterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay) == 0;
        if (tryPerformBarter || blockEntity.barterDelay % (totalBarterDelay / 4) == 0) {
            List<Piglin> piglins = BarteringStationBlockEntity.findNearbyPiglins(level, pos);
            blockEntity.nearbyPiglins = piglins.size();
            if (tryPerformBarter) {
                blockEntity.barterDelay = totalBarterDelay * 2;
                BarteringStationBlockEntity.barterWithPiglins(pos, blockEntity, piglins);
            }
        }
    }

    private static List<Piglin> findNearbyPiglins(Level level, BlockPos pos) {
        Vec3 centerPos = Vec3.m_82512_((Vec3i)pos);
        int horizontalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).horizontalRange;
        int verticalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).verticalRange;
        return level.m_6443_(Piglin.class, new AABB(centerPos.m_82520_((double)(-horizontalRange), (double)(-verticalRange), (double)(-horizontalRange)), centerPos.m_82520_((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), AbstractPiglin::m_34667_);
    }

    private static void barterWithPiglins(BlockPos pos, BarteringStationBlockEntity blockEntity, List<Piglin> piglins) {
        if (piglins.isEmpty() || blockEntity.findFreeResponseSlot().isEmpty()) {
            return;
        }
        int currentPiglin = 0;
        block0: for (int i = 0; i < 6; ++i) {
            ItemStack stack = blockEntity.m_8020_(i);
            if (stack.m_41619_()) continue;
            while (currentPiglin < piglins.size()) {
                if (!PiglinAiHelper.mobInteract(piglins.get(currentPiglin++), stack, pos)) continue;
                blockEntity.m_6596_();
                blockEntity.barterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
                continue block0;
            }
        }
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_OUTPUT;
        }
        return SLOTS_FOR_INPUT;
    }

    public boolean m_7155_(int p_58996_, ItemStack p_58997_, @Nullable Direction p_58998_) {
        return this.m_7013_(p_58996_, p_58997_);
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return true;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.barteringstation.bartering_station");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new BarteringStationMenu(id, inventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int p_58330_, int p_58331_) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)p_58330_, (int)p_58331_);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public ItemStack m_8016_(int p_58387_) {
        ItemStack stack = ContainerHelper.m_18966_(this.items, (int)p_58387_);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.m_6643_()) {
            this.items.set(index, (Object)stack);
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player p_58340_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_58340_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index >= 0 && index < 6) {
            return ModServices.ABSTRACTIONS.isPiglinCurrency(stack);
        }
        return false;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean placeBarterResponseItem(ItemStack stack) {
        while (!stack.m_41619_()) {
            OptionalInt slot = this.findResponseSlotWithSpace(stack);
            if (slot.isEmpty()) {
                slot = this.findFreeResponseSlot();
            }
            if (!slot.isPresent()) break;
            this.mergeStackToSlot(stack, slot.getAsInt());
            if (!stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private OptionalInt findResponseSlotWithSpace(ItemStack stack) {
        for (int i = 6; i < this.m_6643_(); ++i) {
            if (!this.hasSpaceForItem(this.m_8020_(i), stack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private boolean hasSpaceForItem(ItemStack stack1, ItemStack stack2) {
        return !stack1.m_41619_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2) && stack1.m_41753_() && stack1.m_41613_() < stack1.m_41741_() && stack1.m_41613_() < this.m_6893_();
    }

    private OptionalInt findFreeResponseSlot() {
        for (int i = 6; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void mergeStackToSlot(ItemStack stackToMerge, int targetSlot) {
        ItemStack stackToInsert;
        ItemStack stackInSlot = this.m_8020_(targetSlot);
        if (stackInSlot.m_41619_()) {
            stackToInsert = stackToMerge.m_41777_();
            stackToMerge.m_41764_(0);
            if (stackToMerge.m_41782_()) {
                stackToInsert.m_41751_(stackToMerge.m_41783_().m_6426_());
            }
        } else {
            stackToInsert = stackInSlot.m_41777_();
            int transferAmount = stackToMerge.m_41613_();
            transferAmount = Math.min(transferAmount, stackToInsert.m_41741_() - stackToInsert.m_41613_());
            stackToInsert.m_41769_(transferAmount);
            stackToMerge.m_41774_(transferAmount);
        }
        this.m_6836_(targetSlot, stackToInsert);
    }
}

